async function teleportToRandomGroundLocation(bot) {
    const currentPos = bot.entity.position;

    // Generate random X and Z within 100 meters of the current position
    const randomX = currentPos.x + (Math.floor(Math.random() * 200) - 100);  // Offset by -100 to 100
    const randomZ = currentPos.z + (Math.floor(Math.random() * 200) - 100);  // Offset by -100 to 100

    let groundY = null;

    // Find the highest block at the X, Z position that isn't air
    for (let y = bot.world.height; y >= 0; y--) {
        const block = bot.blockAt(randomX, y, randomZ);
        if (block && block.name !== 'air') {
            console.log(`Found the highest block at X:${x}, Z:${z}, Y:${y}. Block: ${block.name}`);
            groundY = y;
            break;
        }
    }

    if (groundY === null) {
        console.log('Could not find the ground; defaulting to Y=64');
        groundY = 64;  // Default to a reasonable height if no ground found
    }

    const destination = new Vec3(randomX, groundY + 2, randomZ);  // +1 to ensure the bot is above the ground
    bot.entity.position = destination;  // Setting the position directly for simplicity
    console.log(`Teleported to: ${destination}`);

    // Optionally, use a chat command if the server supports /tp and bot has permission
    // bot.chat(`/tp ${bot.username} ${randomX} ${groundY + 1} ${randomZ}`);
}

